<?php
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)
/**
 * Widget Name: Projects Carousel
 */
class PBMIT_StaticBoxElement extends Widget_Base{
 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'pbmit_static_box_element';
	}
	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return esc_attr__( 'Xinterio Static Box Element', 'xinterio' );
	}
	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'fas fa-boxes';
	}
	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'xinterio_category' ];
	}
	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);
		if( isset($data['settings']["view-type"]) && !empty($data['settings']["view-type"]) && $data['settings']["view-type"]=='carousel' ){
			wp_enqueue_script( 'swiper' );
			wp_enqueue_style( 'swiper' );
		}
	}
	protected function register_controls() {
		// Style
		$this->start_controls_section(
			'style_section',
			[
				'label'	=> esc_attr__( 'Select Style', 'xinterio' ),
				'tab'	=> Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'style',
			[
				'label'			=> esc_attr__( 'Select StaticBox View Style', 'xinterio' ),
				'description'	=> esc_attr__( 'Select StaticBox View style.', 'xinterio' ),
				'type'			=> 'pbmit_imgselect',
				'label_block'	=> true,
				'thumb_width'	=> '110px',
				'default'		=> '1',
				'options'		=> pbmit_element_template_list( 'static-box', true ),
			]
		);

		$this->add_control(
			'bg_image',
			[
				'label'		=> esc_attr( 'Choose Background Image', 'xinterio' ),
				'type'		=> Controls_Manager::MEDIA,
				'dynamic'	=> [
					'active'	=> true,
				],
				'default'	=> [
					'url'		=> get_template_directory_uri() . '/images/static-box-pattern-img.png',
				],
				'condition'	=> [
					'style'		=> '4',
				],
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'image',
			[
				'label'		=> esc_attr__( 'Choose Image', 'xinterio' ),
				'type'		=> Controls_Manager::MEDIA,
				'dynamic'	=> [
					'active'	=> true,
				],
				'default'	=> [
					'url'		=> get_template_directory_uri() . '/images/static-box.jpg',
				],
			]
		);
		$repeater->add_control(
			'box_number',
			[
				'label'			=> esc_attr__( 'Box Number', 'xinterio' ),
				'description'	=> esc_attr__( '(Optional) Add box number like "01". This will be shown as steps.', 'xinterio' ),
				'type'			=> Controls_Manager::TEXT,
				'dynamic'		=> [
					'active'		=> true,
				],
				'default'		=> '01',
				'placeholder'	=> esc_attr__( 'Enter number', 'xinterio' ),
				'label_block'	=> true,
			]
		);
		$repeater->add_control(
			'label',
			[
				'label'			=> esc_attr__( 'Box Title', 'xinterio' ),
				'type'			=> Controls_Manager::TEXT,
				'default'		=> esc_attr__( 'Box Title', 'xinterio' ),
				'placeholder'	=> esc_attr__( 'Box Title', 'xinterio' ),
				'label_block'	=> true,
			]
		);
		$repeater->add_control(
			'desc',
			[
				'label'			=> esc_attr__( 'Box Description', 'xinterio' ),
				'type'			=> Controls_Manager::TEXTAREA,
				'default'		=> esc_attr__( 'We offer competitive and affordable rates for our interior design .', 'xinterio' ),
				'placeholder'	=> esc_attr__( 'Box Description', 'xinterio' ),
				'label_block'	=> true,
			]
		);
		$repeater->add_control(
			'btn_title',
			[
				'label'			=> esc_attr__( 'Button Title', 'xinterio' ),
				'type'			=> Controls_Manager::TEXT,
				'dynamic'		=> [
					'active'	=> true,
				],
				'default'		=> esc_attr__( 'View Detail', 'xinterio' ),
				'separator'		=> 'before',
				'placeholder'	=> esc_attr__( 'Enter button title here', 'xinterio' ),
				'label_block'	=> true,
			]
		);
		$repeater->add_control(
			'btn_link',
			[
				'label'			=> esc_attr__( 'Button Link', 'xinterio' ),
				'type'			=> Controls_Manager::URL,
				'label_block'	=> true,
				'default'		=> array (
					'url'				=> '#',
					'is_external'		=> '',
					'nofollow'			=> '',
					'custom_attributes'	=> '',
				),
			]
		);
		$this->add_control(
			'boxes',
			[
				'label'		=> esc_attr__( 'Each Static Box Content', 'xinterio' ),
				'type'		=> Controls_Manager::REPEATER,
				'fields'	=> $repeater->get_controls(),
				'default'	=> [
					[
						'image'	=> get_template_directory_uri() . '/images/static-box.jpg',
						'label'	=> esc_attr__( 'Meet Designer', 'xinterio' ),
						'desc'	=> esc_attr__( 'We offer competitive and affordable rates for our interior design .', 'xinterio' ),
					],
					[
						'image'	=> get_template_directory_uri() . '/images/static-box.jpg',
						'label'	=> esc_attr__( 'Finalized layout', 'xinterio' ),
						'desc'	=> esc_attr__( 'We offer competitive and affordable rates for our interior design .', 'xinterio' ),
					],
					[
						'image'	=> get_template_directory_uri() . '/images/static-box.jpg',
						'label'	=> esc_attr__( 'Work in progress', 'xinterio' ),
						'desc'	=> esc_attr__( 'We offer competitive and affordable rates for our interior design .', 'xinterio' ),
					],
				],
				'title_field' => '{{{ label }}}',
			]
		);
		$this->end_controls_section();
		// Appearance
		$this->start_controls_section(
			'appearance_section',
			[
				'label'		=> esc_attr__( 'Column and Carousel Options', 'xinterio' ),
				'tab'		=> Controls_Manager::TAB_CONTENT,
				'condition'	=> [
					'style'		=> '3',
				],
			]
		);
		$this->add_control(
			'view-type',
			[
				'label'			=> esc_attr__( 'How you like to view each Post box?', 'xinterio' ),
				'description'	=> esc_attr__( 'Show as carousel view or simple row-column view.', 'xinterio' ),
				'type'			=> 'pbmit_imgselect',
				'label_block'	=> true,
				'thumb_width'	=> '110px',
				'default'		=> 'row-column',
				'options'		=> [
					'row-column'	=> esc_url( get_template_directory_uri() . '/includes/images/row-column.png' ),
					'carousel'		=> esc_url( get_template_directory_uri() . '/includes/images/carousel.png' ),
				],
				'condition' 	=> [
					'style'			=> '3',
				],
			]
		);
		// Row Column: Heading
		$this->add_control(
			'row_col_options',
			[
				'label'		=> esc_attr__( 'Row-Column Options', 'xinterio' ),
				'type'		=> Controls_Manager::HEADING,
				'separator'	=> 'before',
				'condition'	=> [
					'view-type'	=> 'row-column',
					'style'		=> '3',
				],
			]
		);
		// Carousel: Heading
		$this->add_control(
			'carousel_options',
			[
				'label'		=> esc_attr__( 'Carousel Options', 'xinterio' ),
				'type'		=> Controls_Manager::HEADING,
				'separator'	=> 'before',
				'condition'	=> [
					'view-type'	=> 'carousel',
					'style'		=> '3',
				],
			]
		);
		// Carousel : Loop
		$this->add_control(
			'carousel-loop',
			[
				'label'			=> esc_attr__( 'Carousel: Loop', 'xinterio' ),
				'description'	=> esc_attr__( 'Infinity loop. Duplicate last and first items to get loop illusion.', 'xinterio' ),
				'type'			=> Controls_Manager::SELECT,
				'default'		=> '1',
				'options'		=> [
					'1'				=> esc_attr__( 'Yes', 'xinterio' ),
					'0'				=> esc_attr__( 'No', 'xinterio' ),
				],
				'condition'		=> [
					'view-type'		=> 'carousel',
					'style'			=> '3',
				],
			]
		);
		// Carousel : Autoplay
		$this->add_control(
			'carousel-autoplay',
			[
				'label'			=> esc_attr__( 'Carousel: Autoplay', 'xinterio' ),
				'description'	=> esc_attr__( 'Autoplay of carousel.', 'xinterio' ),
				'type'			=> Controls_Manager::SELECT,
				'default'		=> '0',
				'options'		=> [
					'1'				=> esc_attr__( 'Yes', 'xinterio' ),
					'0'				=> esc_attr__( 'No', 'xinterio' ),
				],
				'condition'		=> [
					'view-type'		=> 'carousel',
					'style'			=> '3',
				],
			]
		);
		// Carousel : Center
		$this->add_control(
			'carousel-center',
			[
				'label'			=> esc_attr__( 'Carousel: Center', 'xinterio' ),
				'description'	=> esc_attr__( 'Center item. Works well with even an odd number of items.', 'xinterio' ),
				'type'			=> Controls_Manager::SELECT,
				'default'		=> '0',
				'options'		=> [
					'1'				=> esc_attr__( 'Yes', 'xinterio' ),
					'0'				=> esc_attr__( 'No', 'xinterio' ),
				],
				'condition'		=> [
					'view-type'		=> 'carousel',
					'style'			=> '3',
				],
			]
		);
		// Carousel : Nav
		$this->add_control(
			'carousel-nav',
			[
				'label'			=> esc_attr__( 'Carousel: Nav', 'xinterio' ),
				'description'	=> esc_attr__( 'Show next/prev buttons.', 'xinterio' ),
				'type'			=> Controls_Manager::SELECT,
				'default'		=> '0',
				'options'		=> [
					'1'				=> esc_attr__( 'Yes', 'xinterio' ),
					'0'				=> esc_attr__( 'No', 'xinterio' ),
					'above'			=> esc_attr__( 'Yes, near heading area', 'xinterio' ),
				],
				'condition'		=> [
					'view-type'		=> 'carousel',
					'style'			=> '3',
				],
			]
		);
		// Carousel : Dots
		$this->add_control(
			'carousel-dots',
			[
				'label'			=> esc_attr__( 'Carousel: Dots', 'xinterio' ),
				'description'	=> esc_attr__( 'Show dots navigation.', 'xinterio' ),
				'type'			=> Controls_Manager::SELECT,
				'default'		=> '0',
				'options'		=> [
					'1'				=> esc_attr__( 'Yes', 'xinterio' ),
					'0'				=> esc_attr__( 'No', 'xinterio' ),
				],
				'condition'		=> [
					'view-type'		=> 'carousel',
					'style'			=> '3',
				],
			]
		);
		// Carousel : autoplaySpeed
		$this->add_control(
			'carousel-autoplayspeed',
			[
				'label'			=> esc_attr__( 'Carousel: autoplaySpeed', 'xinterio' ),
				'description'	=> esc_attr__( 'autoplay speed.', 'xinterio' ),
				'type'			=> Controls_Manager::TEXT,
				'default'		=> '5000',
				'condition'		=> [
					'view-type'		=> 'carousel',
					'style'			=> '3',
				],
			]
		);
		// Columns
		$this->add_control(
			'columns',
			[
				'label'			=> esc_attr__( 'View in Column', 'xinterio' ),
				'description'	=> esc_attr__( 'Select how many column to show.', 'xinterio' ),
				'type'			=> 'pbmit_imgselect',
				'label_block'	=> true,
				'thumb_width'	=> '110px',
				'default'		=> '3',
				'options'		=> [
					'1'				=> esc_url( get_template_directory_uri() . '/includes/images/column-1.png' ),
					'2'				=> esc_url( get_template_directory_uri() . '/includes/images/column-2.png' ),
					'3'				=> esc_url( get_template_directory_uri() . '/includes/images/column-3.png' ),
					'4'				=> esc_url( get_template_directory_uri() . '/includes/images/column-4.png' ),
					'5'				=> esc_url( get_template_directory_uri() . '/includes/images/column-5.png' ),
					'6'				=> esc_url( get_template_directory_uri() . '/includes/images/column-6.png' ),
				],
				'condition'		=> [
					'style'			=> '3',
				],
			]
		);
		$this->end_controls_section();
		// Heading and Subheading
		$this->start_controls_section(
			'heading_section',
			[
				'label'	=> esc_attr__( 'Heading and Subheading', 'xinterio' ),
				'tab'	=> Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title_animation',
			[
				'label'			=> esc_attr__( 'Heading Animation', 'xinterio' ),
				'description'	=> esc_attr__( 'Select Heading Text Animation View style.', 'xinterio' ) . ' ' . pbmit_esc_kses('<br><a target="_blank" href="' . esc_url('https://xinterio-demo.pbminfotech.com/demo1/element/#heading-animations') . '">' . esc_attr__( 'See all anmiation demo here.', 'xinterio' ) . '</a>' ),
				'type'			=> Controls_Manager::SELECT,
				'default'		=> '4',
				'options'		=> [
					'4'				=> esc_attr__( 'No animation', 'xinterio' ),
					'1'				=> esc_attr__( 'Animation Style 1', 'xinterio' ),
					'2'				=> esc_attr__( 'Animation Style 2', 'xinterio' ),
					'3'				=> esc_attr__( 'Animation Style 3', 'xinterio' ),
				],
				'separator'		=> 'before',
			]
		);
		$this->add_control(
			'title',
			[
				'label'		=> esc_attr__( 'Heading', 'xinterio' ),
				'type'		=> Controls_Manager::TEXTAREA,
				'dynamic'	=> [
					'active'	=> true,
				],
				'default'		=> esc_attr__( 'Welcome to our site', 'xinterio' ),
				'placeholder'	=> esc_attr__( 'Enter your heading', 'xinterio' ),
				'label_block'	=> true,
			]
			);
		$this->add_control(
			'title_link',
			[
				'label'			=> esc_attr__( 'Heading Link', 'xinterio' ),
				'type'			=> Controls_Manager::URL,
				'label_block'	=> true,
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label'		=> esc_attr__( 'Subheading', 'xinterio' ),
				'type'		=> Controls_Manager::TEXTAREA,
				'dynamic'	=> [
					'active'	=> true,
				],
				'placeholder'	=> esc_attr__( 'Enter your subtitle', 'xinterio' ),
				'label_block'	=> true,
			]
		);
		$this->add_control(
			'subtitle_link',
			[
				'label'			=> esc_attr__( 'Subheading Link', 'xinterio' ),
				'type'			=> Controls_Manager::URL,
				'label_block'	=> true,
			]
		);
		$this->add_control(
			'desc',
			[
				'label'			=> esc_attr__( 'Description', 'xinterio' ),
				'type'			=> Controls_Manager::TEXTAREA,
				'placeholder'	=> esc_attr__( 'Type your description here', 'xinterio' ),
			]
		);
		$this->add_control(
			'reverse_title',
			[
				'label'			=> esc_attr__( 'Reverse Heading', 'xinterio' ),
				'description'	=> esc_attr__( 'Show Subheading before Heading', 'xinterio' ),
				'type'			=> Controls_Manager::SWITCHER,
				'label_on'		=> esc_attr__( 'Yes', 'xinterio' ),
				'label_off'		=> esc_attr__( 'No', 'xinterio' ),
				'return_value'	=> 'yes',
				'default'		=> '',
			]
		);
		$this->add_responsive_control(
			'text_align',
			[
				'label'		=> esc_attr__( 'Alignment', 'xinterio' ),
				'type'		=> Controls_Manager::CHOOSE,
				'options'	=> [
					'left'	=> [
						'title'	=> esc_attr__( 'Left', 'xinterio' ),
						'icon'	=> 'fa fa-align-left',
					],
					'center'	=> [
						'title'	=> esc_attr__( 'Center', 'xinterio' ),
						'icon'	=> 'fa fa-align-center',
					],
					'right'	=> [
						'title'	=> esc_attr__( 'Right', 'xinterio' ),
						'icon'	=> 'fa fa-align-right',
					],
				],
				'selectors'	=> [
					'{{WRAPPER}} .pbmit-heading-subheading' => 'text-align: {{VALUE}};',
				],
				'dynamic'	=> [
					'active'	=> true,
				],
			]
		);
		$this->end_controls_section();
		// HTML Tags
		$this->start_controls_section(
			'advanced_section',
			[
				'label'	=> pbmit_esc_kses('<img class="pbmit-tab-small-logo" src="'.get_template_directory_uri() . '/includes/images/pbm-small-logo.png" /> ') . esc_attr__( 'Tag Settings', 'xinterio' ),
				'tab'	=> Controls_Manager::TAB_ADVANCED,
			]
		);
		$this->add_control(
			'tag_options',
			[
				'label'		=> esc_attr__( 'Tags for SEO', 'xinterio' ),
				'type'		=> Controls_Manager::HEADING,
				'separator'	=> 'before',
			]
		);
		$this->add_control(
			'title_tag',
			[
				'label'		=> esc_attr__( 'Heading Tag', 'xinterio' ),
				'type'		=> Controls_Manager::SELECT,
				'options'	=> [
					'h1'		=> esc_attr( 'H1' ),
					'h2'		=> esc_attr( 'H2' ),
					'h3'		=> esc_attr( 'H3' ),
					'h4'		=> esc_attr( 'H4' ),
					'h5'		=> esc_attr( 'H5' ),
					'h6'		=> esc_attr( 'H6' ),
					'div'		=> esc_attr( 'DIV' ),
				],
				'default' => esc_attr( 'h2' ),
			]
		);
		$this->add_control(
			'subtitle_tag',
			[
				'label'		=> esc_attr__( 'Subheading Tag', 'xinterio' ),
				'type'		=> Controls_Manager::SELECT,
				'options'	=> [
					'h1'		=> esc_attr( 'H1' ),
					'h2'		=> esc_attr( 'H2' ),
					'h3'		=> esc_attr( 'H3' ),
					'h4'		=> esc_attr( 'H4' ),
					'h5'		=> esc_attr( 'H5' ),
					'h6'		=> esc_attr( 'H6' ),
					'div'		=> esc_attr( 'DIV' ),
				],
				'default'	=> esc_attr( 'h4' ),
			]
		);
		$this->add_control(
			'gap_options',
			[
				'label'		=> esc_attr__( 'Gap between Logo boxes', 'xinterio' ),
				'type'		=> Controls_Manager::HEADING,
				'separator'	=> 'before',
			]
		);
		$this->add_control(
			'gap',
			[
				'label'			=> esc_attr__( 'Box Gap', 'xinterio' ),
				'description'	=> esc_attr__( 'Gap between each Post box.', 'xinterio' ),
				'type'			=> Controls_Manager::SELECT,
				'default'		=> 'default',
				'options'		=> [
					'default'		=> esc_attr__( 'Default Gap', 'xinterio' ),
					'0px'			=> esc_attr__( 'No Gap (0px)', 'xinterio' ),
					'5px'			=> esc_attr__( '5px', 'xinterio' ),
					'10px'			=> esc_attr__( '10px', 'xinterio' ),
					'15px'			=> esc_attr__( '15px', 'xinterio' ),
					'20px'			=> esc_attr__( '20px', 'xinterio' ),
					'25px'			=> esc_attr__( '25px', 'xinterio' ),
					'30px'			=> esc_attr__( '30px', 'xinterio' ),
					'35px'			=> esc_attr__( '35px', 'xinterio' ),
					'40px'			=> esc_attr__( '40px', 'xinterio' ),
					'45px'			=> esc_attr__( '45px', 'xinterio' ),
					'50px'			=> esc_attr__( '50px', 'xinterio' ),
				],
			]
		);
		$this->end_controls_section();
	}
	protected function render() {
		$settings	= $this->get_settings_for_display();
		extract($settings);
		?>
		<?php
		// Starting container
		pbmit_element_container( array(
			'position'	=> 'start',
			'cpt'		=> 'static-box',
			'data'		=> $settings
		) );
		pbmit_heading_subheading($settings, true);
		?>
		<div class="pbmit-element-posts-wrapper <?php if( !empty($settings['view-type']) && trim($settings['view-type'])=='carousel' ){ ?>swiper-container<?php } ?> row multi-columns-row">
				<?php if($style == '2'){ ?>
					<div class= "pbmit-main-static-slider d-flex align-items-center justify-content-between">

						<div class="swiper-static-slide-nav col-sm-12 col-md-6">
							<ul class="pbmit-hover-inner">
								<?php foreach ( $settings['boxes'] as $box ) {
									$button_html	 = '';
									$box_number_html = '';
									$label_html		 = ( !empty($box['label']) ) ? '<div class="pbmit-static-box-title"><h5>'.esc_html($box['label']).'</h5></div>' : '' ;
									$desc_html		 = ( !empty($box['desc']) ) ? '<div class="pbmit-static-box-desc">'.esc_html($box['desc']).'</div>' : '' ;
									$box_number_html = ( !empty($box['box_number']) ) ? '<div class="pbmit-box-number">'.esc_attr($box['box_number']).'</div>' : '';
									?>
									<?php if( !empty($box['btn_title']) && !empty($box['btn_link']['url']) ){
										$button_html = '<div class="pbmit-static-btn">' . pbmit_link_render($box['btn_link'], 'start' ) . pbmit_esc_kses($box['btn_title']) . pbmit_link_render($box['btn_link'], 'end' ) . '</div>';
									} ?>
									<li class="pbmit-title-wrapper">
										<div class="pbmit-static-box-number">
											<?php echo pbmit_esc_kses($box_number_html); ?>
										</div>
										<div class="pbmit-content-box">
											<?php echo pbmit_esc_kses($label_html); ?>
											<?php echo pbmit_esc_kses($desc_html); ?>
											<?php echo pbmit_esc_kses($button_html); ?>
										</div>
									</li>
									
								<?php } ?>
							</ul>
						</div>	<!-- End Of Title Box -->
						<div class="swiper-static-slide-images col-sm-12 col-md-6">
							<div class="swiper-container pbmit-static-image">
								<div class="swiper-wrapper">

									<?php foreach ( $settings['boxes'] as $box ) {
										// Media image
										$image_html	= '' ;
										if( !empty($box['image']) ){
											$image_html = '<img src="'.$box['image']['url'].'" alt="'.esc_attr($box['label']).'" />';
										} ?>

										<div class="swiper-slide">
											<?php echo pbmit_esc_kses($image_html); ?>
										</div>
									<?php } ?>
								</div>
							</div>
						</div>	<!-- End Of image Box -->
					</div>	<!-- End Of main-static slide -->
				<?php } else if($style =='4'){ ?>
					<div class= "pbmit-main-static-slider d-flex" style= "background-image: url(<?php echo pbmit_esc_kses($settings['bg_image']['url'] );?>);" >
						<div class="swiper-static-slide-nav col-sm-12 col-md-4">
							<ul class="pbmit-hover-inner">
								<?php foreach ( $settings['boxes'] as $box ) {

									$box_number_html = '';
									$box_number_html = ( !empty($box['box_number']) ) ? '<div class="pbmit-box-number">'.esc_attr($box['box_number']).'</div>' : '';
									?>

									<li class="pbmit-title-wrapper">
										<div class="pbmit-static-box-number">
											<?php echo pbmit_esc_kses($box_number_html); ?>
										</div>
									</li>
								<?php } ?>
							</ul>
						</div>	<!-- End Of Title Box -->
						<div class="pbmit-static-title-desc col-md-4">
							<div class="pbmit-static-title-desc-inner">
								<div class="swiper-container pbmit-static-desc">
									<div class="swiper-wrapper">
										<?php foreach ( $settings['boxes'] as $box ) {

											//label
											$button_html= '';
											$label_html	= ( !empty($box['label']) ) ? '<div class="pbmit-static-box-title"><h5>'.esc_html($box['label']).'</h5></div>' : '' ;
											//desc
											$desc_html	= ( !empty($box['desc']) ) ? '<div class="pbmit-static-box-desc">'.esc_html($box['desc']).'</div>' : '' ;
											//button
											if( !empty($box['btn_title']) && !empty($box['btn_link']['url']) ){
												$button_html = '<div class="pbmit-static-btn">' . pbmit_link_render($box['btn_link'], 'start' ) . pbmit_esc_kses($box['btn_title']) . pbmit_link_render($box['btn_link'], 'end' ) . '</div>';
											} ?>

											<div class="swiper-slide">
												<div class="pbmit-content-box">
													<?php echo pbmit_esc_kses($label_html); ?>
													<?php echo pbmit_esc_kses($desc_html); ?>
													<?php echo pbmit_esc_kses($button_html); ?>
												</div>
											</div>

										<?php } ?>
									</div>
								</div>
							</div>
						</div>

						<div class="swiper-static-slide-images col-sm-12 col-md-4">
							<div class="swiper-container pbmit-static-image">
								<div class="swiper-wrapper">

									<?php foreach ( $settings['boxes'] as $box ) {
										// Media image
										$image_html	= '' ;
										if( !empty($box['image']) ){
											$image_html = '<img src="'.$box['image']['url'].'" alt="'.esc_attr($box['label']).'" />';
										} ?>

										<div class="swiper-slide">
											<?php echo pbmit_esc_kses($image_html); ?>
										</div>
									<?php } ?>
								</div>
							</div>
						</div>	<!-- End Of image Box -->

					</div>	<!-- End Of main-static slide -->
				<?php } else {
				$return = '';
					foreach( $settings['boxes'] as $box ){
						$image_html	= $label_html = $button_html = $btn_link = $desc_html = $box_number_html = '' ;
						$box_number_html = ( !empty($box['box_number']) ) ? '<div class="pbmit-box-number">'.esc_attr($box['box_number']).'</div>' : '';
						$label_html		 = ( !empty($box['label']) ) ? '<h4 class="pbmit-static-box-title">'.esc_html($box['label']).'</h4>' : '' ;
						// Button
						if( !empty($box['btn_title']) && !empty($box['btn_link']['url']) ){
							$button_html = '<div class="pbmit-static-btn">' . pbmit_link_render($box['btn_link'], 'start' ) . pbmit_esc_kses($box['btn_title']) . pbmit_link_render($box['btn_link'], 'end' ) . '</div>';
						}
						//description
						$desc_html	= ( !empty($box['desc']) ) ? '<div class="pbmit-static-box-desc">'.esc_html($box['desc']).'</div>' : '' ;
						//Image
						$image_html	= ( !empty($box['image']['url']) ) ? '<img src="'.esc_url($box['image']['url']).'" alt="'.esc_attr($box['label']).'" />' : '' ;
						// Template
						if( file_exists( locate_template( '/theme-parts/static-box/static-box-style-'.esc_attr($style).'.php', false, false ) ) ){
							$return .= pbmit_element_block_container( array(
								'position'	=> 'start',
								'column'	=> $columns,
								'cpt'		=> 'static-box',
								'style'		=> $style
							) );
							ob_start();
							include( locate_template( '/theme-parts/static-box/static-box-style-'.esc_attr($style).'.php', false, false ) );
							$return .= ob_get_contents();
							ob_end_clean();
							$return .= pbmit_element_block_container( array(
								'position'	=> 'end',
							) );
						}
					} // foreach
				echo pbmit_esc_kses($return);
			} ?>
		</div>
		<?php
		// Ending wrapper of the whole arear
		pbmit_element_container( array(
			'position'	=> 'end',
			'cpt'		=> 'static-box',
			'data'		=> $settings
		) );
		?>
		<?php
	}
	protected function content_template() {}
}
// After the Schedule class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register( new PBMIT_StaticBoxElement() );