<?php
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)
/**
 * Widget Name: Projects Carousel
 */
class PBMIT_BEFOREAFTERElement extends Widget_Base{
 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'pbmit_beforeafter_element';
	}
	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return esc_attr__( 'Xinterio Before After Element', 'xinterio' );
	}
	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'fas fa-exchange-alt';
	}
	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'xinterio_category' ];
	}
	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);
		wp_enqueue_style( 'twentytwenty' );
		wp_enqueue_script( 'jquery-eventmove' );
		wp_enqueue_script( 'twentytwenty' );
		
	}
	protected function register_controls() {
		$this->start_controls_section(
            'content_section',
            [
                'label'	=> esc_attr__( 'Content', 'xinterio' ),
                'tab'	=> Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'image1',
            [
                'label'		=> esc_attr__( 'Image 1', 'xinterio' ),
                'type'		=> Controls_Manager::MEDIA,
                'default'	=> [
                    'url'		=> get_template_directory_uri() . '/images/before-after-1.jpg',
                ],
            ]
        );
        $this->add_control(
            'image2',
            [
                'label'		=> esc_attr__( 'Image 2', 'xinterio' ),
                'type'		=> Controls_Manager::MEDIA,
                'default'	=> [
                    'url'		=> get_template_directory_uri() . '/images/before-after-2.jpg',
                ],
            ]
        );
        $this->add_control(
            'offset',
            [
                'label'			=> esc_attr__( 'Offset', 'xinterio' ),
                'description'	=> esc_attr__( 'How much of the before image is visible when the page loads', 'xinterio' ),
                'type'			=> Controls_Manager::SLIDER,
                'default'		=> [
                    'size'			=> 0.5,
                    'unit'			=> '',
                ],
                'range'			=> [
                    ''				=> [
                        'min'			=> 0,
                        'max'			=> 1,
                        'step'			=> 0.01,
                    ],
                ],
            ]
        );
        $this->add_control(
            'direction',
            [
                'label'			=> esc_attr__( 'Direction', 'xinterio' ),
                'description'	=> esc_attr__( 'Orientation of the before and after images', 'xinterio' ),
                'type'			=> Controls_Manager::SELECT,
                'default'		=> 'horizontal',
                'options'		=> [
                    'horizontal'	=> esc_attr__( 'Horizontal', 'xinterio' ),
                    'vertical'		=> esc_attr__( 'Vertical', 'xinterio' ),
                ],
            ]
        );
        $this->end_controls_section();
	}
	protected function render() {
		$image1_url = $image2_url ='';
		$offset_val		= '0.5';
		$direction_val	= 'horizontal';
		
		$settings	= $this->get_settings_for_display();
		extract($settings);

		if( !empty($image1['url']) ){
			$image1_url = $image1['url'];
		}
		if( !empty($image2['url']) ){
			$image2_url = $image2['url'];
		}
		if( !empty($offset['size']) && is_numeric($offset['size']) && $offset['size'] >= 0 && $offset['size'] <= 1 ){
			$offset_val = $offset['size'];
		}
		if( !empty($direction) && in_array( $direction, array( 'horizontal', 'vertical' ) ) ){
			$direction_val = $direction;
		}
		?>

		<div class="pbmit-ele pbmit-ele-before-after" data-before-after-direction="<?php echo esc_attr($direction_val); ?>" data-before-after-offset="<?php echo esc_attr($offset_val); ?>">
			<?php
			// Before After Image
			if( !empty($image1_url) && !empty($image2_url) ){
				?>
				<div class="pbmit-ele-before-after-inner">
					<img src="<?php echo esc_url($image1_url); ?>" class="pbmit-before-image" alt="<?php esc_attr_e('Before Image', 'xinterio'); ?>">
					<img src="<?php echo esc_url($image2_url); ?>" class="pbmit-after-image pbmit-hide" alt="<?php esc_attr_e('After Image', 'xinterio'); ?>">
				</div>
				<?php
			} else {
				if( current_user_can( 'administrator' ) ){
					esc_attr_e('Please select before and after images from the widget settings.', 'xinterio');
				}
			}
			?>
		</div>

		<?php
	}

	protected function _content_template() {
		?>
		<#
		// Ensure the necessary controls are set or provide default values
		var image1Url	= settings.image1.url ? settings.image1.url : '';
		var image2Url	= settings.image2.url ? settings.image2.url : '';
		var offset		= settings.offset && settings.offset.size !== '' ? settings.offset.size : 0.5;
		var direction	= settings.direction ? settings.direction : 'horizontal';
		var pbmit_id	= 'pbmit-before-after-' + Math.floor(Math.random() * 10000);
		#>
		<div class="pbmit-ele pbmit-ele-before-after" data-before-after-direction="{{ direction }}" data-before-after-offset="{{ offset }}">
			<div id="{{ pbmit_id }}" class="pbmit-ele-before-after-inner">
				<img src="{{ image1Url }}" class="pbmit-before-image" alt="Before Image" />
				<img src="{{ image2Url }}" class="pbmit-after-image pbmit-hide" alt="After Image" />
			</div>
		</div>
		<?php
	}

	protected function content_template() {}

}
// After the Schedule class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register( new PBMIT_BEFOREAFTERElement() );
